--
-- Table structure for table `read_notification`
--

CREATE TABLE `read_notification` (
  `id` int(11) NOT NULL,
  `student_id` int(11) DEFAULT NULL,
  `parent_id` int(10) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `notification_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `read_notification`
--

INSERT INTO `read_notification` (`id`, `student_id`, `parent_id`, `staff_id`, `notification_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 3, NULL, NULL, 1, 'no', '2022-11-24 06:47:00', '');

-- --------------------------------------------------------

--
-- Table structure for table `reference`
--

CREATE TABLE `reference` (
  `id` int(11) NOT NULL,
  `reference` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `slug` varchar(150) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `is_superadmin` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `slug`, `is_active`, `is_system`, `is_superadmin`, `created_at`, `updated_at`) VALUES
(1, 'Admin', NULL, 0, 1, 0, '2018-06-30 13:39:11', '0000-00-00 00:00:00'),
(2, 'Teacher', NULL, 0, 1, 0, '2018-06-30 13:39:14', '0000-00-00 00:00:00'),
(3, 'Accountant', NULL, 0, 1, 0, '2018-06-30 13:39:17', '0000-00-00 00:00:00'),
(4, 'Librarian', NULL, 0, 1, 0, '2018-06-30 13:39:21', '0000-00-00 00:00:00'),
(6, 'Receptionist', NULL, 0, 1, 0, '2018-07-02 03:39:03', '0000-00-00 00:00:00'),
(7, 'Super Admin', NULL, 0, 1, 1, '2018-07-11 12:11:29', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `roles_permissions`
--

CREATE TABLE `roles_permissions` (
  `id` int(11) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `perm_cat_id` int(11) DEFAULT NULL,
  `can_view` int(11) DEFAULT NULL,
  `can_add` int(11) DEFAULT NULL,
  `can_edit` int(11) DEFAULT NULL,
  `can_delete` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `roles_permissions`
--

INSERT INTO `roles_permissions` (`id`, `role_id`, `perm_cat_id`, `can_view`, `can_add`, `can_edit`, `can_delete`, `created_at`) VALUES
(3, 1, 3, 1, 1, 1, 1, '2018-07-06 13:12:08'),
(4, 1, 4, 1, 1, 1, 1, '2018-07-06 13:13:01'),
(6, 1, 5, 1, 1, 0, 1, '2018-07-02 14:49:46'),
(8, 1, 7, 1, 1, 1, 1, '2018-07-06 13:13:29'),
(9, 1, 8, 1, 1, 1, 1, '2018-07-06 13:13:53'),
(10, 1, 17, 1, 1, 1, 1, '2018-07-06 13:18:56'),
(11, 1, 78, 1, 1, 1, 1, '2018-07-03 04:19:43'),
(13, 1, 69, 1, 1, 1, 1, '2018-07-06 13:14:15'),
(14, 1, 70, 1, 1, 1, 1, '2018-07-06 13:14:39'),
(23, 1, 12, 1, 1, 1, 1, '2018-07-06 13:15:38'),
(24, 1, 13, 1, 1, 1, 1, '2018-07-06 13:18:28'),
(26, 1, 15, 1, 1, 1, 0, '2018-07-02 14:54:21'),
(28, 1, 19, 1, 1, 1, 0, '2018-07-02 15:01:10'),
(29, 1, 20, 1, 1, 1, 1, '2018-07-06 13:19:50'),
(30, 1, 76, 1, 1, 1, 0, '2018-07-02 15:01:10'),
(31, 1, 21, 1, 1, 1, 0, '2018-07-02 15:01:38'),
(32, 1, 22, 1, 1, 1, 1, '2018-07-02 15:02:05'),
(33, 1, 23, 1, 1, 1, 1, '2018-07-06 13:20:17'),
(34, 1, 24, 1, 1, 1, 1, '2018-07-06 13:20:39'),
(35, 1, 25, 1, 1, 1, 1, '2018-07-06 13:22:35'),
(37, 1, 77, 1, 1, 1, 1, '2018-07-06 13:19:50'),
(43, 1, 32, 1, 1, 1, 1, '2018-07-06 13:52:05'),
(44, 1, 33, 1, 1, 1, 1, '2018-07-06 13:52:29'),
(45, 1, 34, 1, 1, 1, 1, '2018-07-06 13:53:59'),
(46, 1, 35, 1, 1, 1, 1, '2018-07-06 13:54:34'),
(47, 1, 104, 1, 1, 1, 1, '2018-07-06 13:53:08'),
(48, 1, 37, 1, 1, 1, 1, '2018-07-06 13:55:30'),
(49, 1, 38, 1, 1, 1, 1, '2018-07-09 08:45:27'),
(53, 1, 43, 1, 1, 1, 1, '2018-07-10 13:00:31'),
(58, 1, 52, 1, 1, 0, 1, '2018-07-09 06:49:43'),
(61, 1, 55, 1, 1, 1, 1, '2018-07-02 12:54:16'),
(67, 1, 61, 1, 1, 0, 1, '2018-07-09 09:29:19'),
(68, 1, 62, 1, 1, 0, 1, '2018-07-09 09:29:19'),
(69, 1, 63, 1, 1, 0, 1, '2018-07-09 07:21:38'),
(70, 1, 64, 1, 1, 1, 1, '2018-07-09 06:32:19'),
(71, 1, 65, 1, 1, 1, 1, '2018-07-09 06:41:21'),
(72, 1, 66, 1, 1, 1, 1, '2018-07-09 06:43:09'),
(73, 1, 67, 1, 1, 1, 1, '2018-07-09 06:44:47'),
(74, 1, 79, 1, 1, 0, 1, '2018-07-02 15:34:53'),
(75, 1, 80, 1, 1, 1, 1, '2018-07-06 13:11:23'),
(76, 1, 81, 1, 1, 1, 1, '2018-07-06 13:11:23'),
(78, 1, 83, 1, 1, 1, 1, '2018-07-06 13:11:23'),
(79, 1, 84, 1, 1, 1, 1, '2018-07-06 13:11:23'),
(80, 1, 85, 1, 1, 1, 1, '2018-07-12 03:46:00'),
(83, 1, 88, 1, 1, 1, 0, '2018-07-03 15:34:20'),
(87, 1, 92, 1, 1, 1, 1, '2018-06-26 07:03:43'),
(88, 1, 93, 1, 1, 1, 1, '2018-07-09 04:54:20'),
(94, 1, 82, 1, 1, 1, 1, '2018-07-06 13:11:23'),
(120, 1, 39, 1, 1, 1, 1, '2018-07-06 13:56:28'),
(140, 1, 110, 1, 1, 1, 1, '2018-07-06 13:25:08'),
(141, 1, 111, 1, 1, 1, 1, '2018-07-06 13:26:28'),
(142, 1, 112, 1, 1, 1, 1, '2018-07-06 13:26:28'),
(145, 1, 94, 1, 1, 0, 0, '2018-07-09 04:50:40'),
(147, 2, 43, 1, 1, 1, 1, '2018-06-30 11:16:24'),
(148, 2, 44, 1, 0, 0, 0, '2018-06-27 14:47:09'),
(149, 2, 46, 1, 0, 0, 0, '2018-06-28 03:56:41'),
(156, 1, 9, 1, 1, 1, 1, '2018-07-06 13:14:53'),
(157, 1, 10, 1, 1, 1, 1, '2018-07-06 13:15:12'),
(159, 1, 40, 1, 1, 1, 1, '2018-07-09 08:39:40'),
(160, 1, 41, 1, 1, 1, 1, '2018-07-06 13:57:09'),
(161, 1, 42, 1, 1, 1, 1, '2018-07-09 08:43:14'),
(169, 1, 27, 1, 1, 0, 1, '2018-07-02 15:06:58'),
(178, 1, 54, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(179, 1, 56, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(180, 1, 57, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(181, 1, 58, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(182, 1, 59, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(183, 1, 60, 1, 0, 1, 0, '2018-07-05 12:39:22'),
(190, 1, 105, 1, 0, 0, 0, '2018-07-02 14:43:25'),
(193, 1, 6, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(194, 1, 68, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(196, 1, 72, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(197, 1, 73, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(198, 1, 74, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(199, 1, 75, 1, 0, 0, 0, '2018-07-02 14:49:46'),
(201, 1, 14, 1, 0, 0, 0, '2018-07-02 14:52:03'),
(203, 1, 16, 1, 0, 0, 0, '2018-07-02 14:54:21'),
(204, 1, 26, 1, 0, 0, 0, '2018-07-02 15:02:05'),
(206, 1, 29, 1, 0, 0, 0, '2018-07-02 15:13:54'),
(207, 1, 30, 1, 0, 0, 0, '2018-07-02 15:13:54'),
(208, 1, 31, 1, 0, 0, 0, '2018-07-02 15:15:36'),
(215, 1, 50, 1, 0, 0, 0, '2018-07-02 15:34:53'),
(216, 1, 51, 1, 0, 0, 0, '2018-07-02 15:34:53'),
(222, 1, 1, 1, 1, 1, 1, '2018-07-10 13:00:31'),
(225, 1, 108, 1, 1, 1, 1, '2018-07-09 05:47:26'),
(227, 1, 91, 1, 0, 0, 0, '2018-07-03 05:19:27'),
(229, 1, 89, 1, 0, 0, 0, '2018-07-03 05:30:53'),
(230, 10, 53, 0, 1, 0, 0, '2018-07-03 07:22:55'),
(231, 10, 54, 0, 0, 1, 0, '2018-07-03 07:22:55'),
(232, 10, 55, 1, 1, 1, 1, '2018-07-03 07:28:42'),
(233, 10, 56, 0, 0, 1, 0, '2018-07-03 07:22:55'),
(235, 10, 58, 0, 0, 1, 0, '2018-07-03 07:22:55'),
(236, 10, 59, 0, 0, 1, 0, '2018-07-03 07:22:55'),
(239, 10, 1, 1, 1, 1, 1, '2018-07-03 07:46:43'),
(241, 10, 3, 1, 0, 0, 0, '2018-07-03 07:53:56'),
(242, 10, 2, 1, 0, 0, 0, '2018-07-03 07:54:39'),
(243, 10, 4, 1, 0, 1, 1, '2018-07-03 08:01:24'),
(245, 10, 107, 1, 0, 0, 0, '2018-07-03 08:06:41'),
(246, 10, 5, 1, 1, 0, 1, '2018-07-03 08:08:18'),
(247, 10, 7, 1, 1, 1, 1, '2018-07-03 08:12:07'),
(248, 10, 68, 1, 0, 0, 0, '2018-07-03 08:12:53'),
(249, 10, 69, 1, 1, 1, 1, '2018-07-03 08:19:46'),
(250, 10, 70, 1, 0, 0, 1, '2018-07-03 08:22:40'),
(251, 10, 72, 1, 0, 0, 0, '2018-07-03 08:26:46'),
(252, 10, 73, 1, 0, 0, 0, '2018-07-03 08:26:46'),
(253, 10, 74, 1, 0, 0, 0, '2018-07-03 08:28:34'),
(254, 10, 75, 1, 0, 0, 0, '2018-07-03 08:28:34'),
(255, 10, 9, 1, 1, 1, 1, '2018-07-03 08:32:22'),
(256, 10, 10, 1, 1, 1, 1, '2018-07-03 08:33:09'),
(257, 10, 11, 1, 0, 0, 0, '2018-07-03 08:33:09'),
(258, 10, 12, 1, 1, 1, 1, '2018-07-03 08:38:40'),
(259, 10, 13, 1, 1, 1, 1, '2018-07-03 08:38:40'),
(260, 10, 14, 1, 0, 0, 0, '2018-07-03 08:38:53'),
(261, 10, 15, 1, 1, 1, 0, '2018-07-03 08:41:28'),
(262, 10, 16, 1, 0, 0, 0, '2018-07-03 08:42:12'),
(263, 10, 17, 1, 1, 1, 1, '2018-07-03 08:44:30'),
(264, 10, 19, 1, 1, 1, 0, '2018-07-03 08:45:45'),
(265, 10, 20, 1, 1, 1, 1, '2018-07-03 08:48:51'),
(266, 10, 76, 1, 0, 0, 0, '2018-07-03 08:51:21'),
(267, 10, 21, 1, 1, 1, 0, '2018-07-03 08:52:45'),
(268, 10, 22, 1, 1, 1, 1, '2018-07-03 08:55:00'),
(269, 10, 23, 1, 1, 1, 1, '2018-07-03 08:57:16'),
(270, 10, 24, 1, 1, 1, 1, '2018-07-03 08:57:49'),
(271, 10, 25, 1, 1, 1, 1, '2018-07-03 08:57:49'),
(272, 10, 26, 1, 0, 0, 0, '2018-07-03 08:58:25'),
(273, 10, 77, 1, 1, 1, 1, '2018-07-03 08:59:57'),
(274, 10, 27, 1, 1, 0, 1, '2018-07-03 09:00:36'),
(275, 10, 28, 1, 1, 1, 1, '2018-07-03 09:03:09'),
(276, 10, 29, 1, 0, 0, 0, '2018-07-03 09:04:03'),
(277, 10, 30, 1, 0, 0, 0, '2018-07-03 09:04:03'),
(278, 10, 31, 1, 0, 0, 0, '2018-07-03 09:04:03'),
(279, 10, 32, 1, 1, 1, 1, '2018-07-03 09:05:42'),
(280, 10, 33, 1, 1, 1, 1, '2018-07-03 09:06:32'),
(281, 10, 34, 1, 1, 1, 1, '2018-07-03 09:08:03'),
(282, 10, 35, 1, 1, 1, 1, '2018-07-03 09:08:41'),
(283, 10, 104, 1, 1, 1, 1, '2018-07-03 09:10:43'),
(284, 10, 37, 1, 1, 1, 1, '2018-07-03 09:12:42'),
(285, 10, 38, 1, 1, 1, 1, '2018-07-03 09:13:56'),
(286, 10, 39, 1, 1, 1, 1, '2018-07-03 09:15:39'),
(287, 10, 40, 1, 1, 1, 1, '2018-07-03 09:17:22'),
(288, 10, 41, 1, 1, 1, 1, '2018-07-03 09:18:54'),
(289, 10, 42, 1, 1, 1, 1, '2018-07-03 09:19:31'),
(290, 10, 43, 1, 1, 1, 1, '2018-07-03 09:21:15'),
(291, 10, 44, 1, 0, 0, 0, '2018-07-03 09:22:06'),
(292, 10, 46, 1, 0, 0, 0, '2018-07-03 09:22:06'),
(293, 10, 50, 1, 0, 0, 0, '2018-07-03 09:22:59'),
(294, 10, 51, 1, 0, 0, 0, '2018-07-03 09:22:59'),
(295, 10, 60, 0, 0, 1, 0, '2018-07-03 09:25:05'),
(296, 10, 61, 1, 1, 1, 1, '2018-07-03 09:26:52'),
(297, 10, 62, 1, 1, 1, 1, '2018-07-03 09:28:53'),
(298, 10, 63, 1, 1, 0, 0, '2018-07-03 09:29:37'),
(299, 10, 64, 1, 1, 1, 1, '2018-07-03 09:30:27'),
(300, 10, 65, 1, 1, 1, 1, '2018-07-03 09:32:51'),
(301, 10, 66, 1, 1, 1, 1, '2018-07-03 09:32:51'),
(302, 10, 67, 1, 0, 0, 0, '2018-07-03 09:32:51'),
(303, 10, 78, 1, 1, 1, 1, '2018-07-04 07:40:04'),
(307, 1, 126, 1, 0, 0, 0, '2018-07-03 12:56:13'),
(310, 1, 119, 1, 0, 0, 0, '2018-07-03 13:45:00'),
(311, 1, 120, 1, 0, 0, 0, '2018-07-03 13:45:00'),
(312, 1, 107, 1, 0, 0, 0, '2018-07-03 13:45:12'),
(313, 1, 122, 1, 0, 0, 0, '2018-07-03 13:49:37'),
(315, 1, 123, 1, 0, 0, 0, '2018-07-03 13:57:03'),
(317, 1, 124, 1, 0, 0, 0, '2018-07-03 13:59:14'),
(320, 1, 47, 1, 0, 0, 0, '2018-07-03 14:31:12'),
(321, 1, 121, 1, 0, 0, 0, '2018-07-03 14:31:12'),
(322, 1, 109, 1, 1, 1, 1, '2018-07-03 14:40:54'),
(369, 1, 102, 1, 1, 1, 1, '2018-07-11 15:31:47'),
(372, 10, 79, 1, 1, 0, 0, '2018-07-04 07:40:04'),
(373, 10, 80, 1, 1, 1, 1, '2018-07-04 07:53:09'),
(374, 10, 81, 1, 1, 1, 1, '2018-07-04 07:53:50'),
(375, 10, 82, 1, 1, 1, 1, '2018-07-04 07:56:54'),
(376, 10, 83, 1, 1, 1, 1, '2018-07-04 07:57:55'),
(377, 10, 84, 1, 1, 1, 1, '2018-07-04 08:00:26'),
(378, 10, 85, 1, 1, 1, 1, '2018-07-04 08:02:54'),
(379, 10, 86, 1, 1, 1, 1, '2018-07-04 08:16:18'),
(380, 10, 87, 1, 0, 0, 0, '2018-07-04 08:19:49'),
(381, 10, 88, 1, 1, 1, 0, '2018-07-04 08:21:20'),
(382, 10, 89, 1, 0, 0, 0, '2018-07-04 08:21:51'),
(383, 10, 90, 1, 1, 0, 1, '2018-07-04 08:25:01'),
(384, 10, 91, 1, 0, 0, 0, '2018-07-04 08:25:01'),
(385, 10, 108, 1, 1, 1, 1, '2018-07-04 08:27:46'),
(386, 10, 109, 1, 1, 1, 1, '2018-07-04 08:28:26'),
(387, 10, 110, 1, 1, 1, 1, '2018-07-04 08:32:43'),
(388, 10, 111, 1, 1, 1, 1, '2018-07-04 08:33:21'),
(389, 10, 112, 1, 1, 1, 1, '2018-07-04 08:35:06'),
(390, 10, 127, 1, 0, 0, 0, '2018-07-04 08:35:06'),
(391, 10, 93, 1, 1, 1, 1, '2018-07-04 08:37:14'),
(392, 10, 94, 1, 1, 0, 0, '2018-07-04 08:38:02'),
(394, 10, 95, 1, 0, 0, 0, '2018-07-04 08:38:44'),
(395, 10, 102, 1, 1, 1, 1, '2018-07-04 08:41:02'),
(396, 10, 106, 1, 0, 0, 0, '2018-07-04 08:41:39'),
(397, 10, 113, 1, 0, 0, 0, '2018-07-04 08:42:37'),
(398, 10, 114, 1, 0, 0, 0, '2018-07-04 08:42:37'),
(399, 10, 115, 1, 0, 0, 0, '2018-07-04 08:48:45'),
(400, 10, 116, 1, 0, 0, 0, '2018-07-04 08:48:45'),
(401, 10, 117, 1, 0, 0, 0, '2018-07-04 08:49:43'),
(402, 10, 118, 1, 0, 0, 0, '2018-07-04 08:49:43'),
(411, 1, 2, 1, 0, 0, 0, '2018-07-04 11:46:10'),
(412, 1, 11, 1, 0, 0, 0, '2018-07-04 12:24:05'),
(416, 2, 3, 1, 1, 1, 1, '2018-07-10 10:17:12'),
(428, 2, 4, 1, 1, 1, 1, '2018-07-05 05:40:38'),
(432, 1, 128, 0, 1, 0, 1, '2018-07-05 11:39:50'),
(434, 1, 125, 1, 0, 0, 0, '2018-07-06 13:29:26'),
(435, 1, 96, 1, 1, 1, 1, '2018-07-09 04:33:54'),
(437, 1, 98, 1, 1, 1, 1, '2018-07-09 04:44:17'),
(444, 1, 99, 1, 0, 0, 0, '2018-07-06 15:11:22'),
(445, 1, 48, 1, 0, 0, 0, '2018-07-06 15:19:35'),
(446, 1, 49, 1, 0, 0, 0, '2018-07-06 15:19:35'),
(448, 1, 71, 1, 0, 0, 0, '2018-07-08 07:17:06'),
(453, 1, 106, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(454, 1, 113, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(455, 1, 114, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(456, 1, 115, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(457, 1, 116, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(458, 1, 117, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(459, 1, 118, 1, 0, 0, 0, '2018-07-09 04:17:33'),
(461, 1, 97, 1, 0, 0, 0, '2018-07-09 04:30:16'),
(462, 1, 95, 1, 0, 0, 0, '2018-07-09 04:48:41'),
(464, 1, 86, 1, 1, 1, 1, '2018-07-09 09:39:48'),
(466, 1, 129, 0, 1, 0, 1, '2018-07-09 05:09:30'),
(467, 1, 87, 1, 0, 0, 0, '2018-07-09 05:11:59'),
(468, 1, 90, 1, 1, 0, 1, '2018-07-09 05:22:50'),
(471, 1, 53, 0, 1, 0, 0, '2018-07-09 06:50:44'),
(474, 1, 130, 1, 1, 0, 1, '2018-07-09 14:26:36'),
(476, 1, 131, 1, 0, 0, 0, '2018-07-09 08:23:32'),
(477, 2, 1, 1, 1, 1, 1, '2018-07-11 10:26:27'),
(478, 2, 2, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(479, 2, 47, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(480, 2, 105, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(482, 2, 119, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(483, 2, 120, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(485, 2, 15, 1, 1, 1, 0, '2018-07-10 10:17:12'),
(486, 2, 16, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(487, 2, 122, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(492, 2, 21, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(493, 2, 22, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(494, 2, 23, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(495, 2, 24, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(496, 2, 25, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(498, 2, 77, 1, 0, 0, 0, '2018-07-12 03:50:27'),
(499, 2, 27, 1, 1, 0, 1, '2018-07-10 10:17:12'),
(502, 2, 93, 1, 1, 1, 1, '2018-07-10 10:17:12'),
(503, 2, 94, 1, 1, 0, 0, '2018-07-10 10:17:12'),
(504, 2, 95, 1, 0, 0, 0, '2018-07-10 10:17:12'),
(505, 3, 5, 1, 1, 0, 1, '2018-07-10 10:37:30'),
(506, 3, 6, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(507, 3, 7, 1, 1, 1, 1, '2018-07-10 10:37:30'),
(508, 3, 8, 1, 1, 1, 1, '2018-07-10 10:37:30'),
(509, 3, 68, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(510, 3, 69, 1, 1, 1, 1, '2018-07-10 10:37:30'),
(511, 3, 70, 1, 1, 1, 1, '2018-07-10 10:37:30'),
(512, 3, 71, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(513, 3, 72, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(514, 3, 73, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(515, 3, 74, 1, 0, 0, 0, '2018-07-10 10:37:30'),
(517, 3, 75, 1, 0, 0, 0, '2018-07-10 10:40:38'),
(518, 3, 9, 1, 1, 1, 1, '2018-07-10 10:40:38'),
(519, 3, 10, 1, 1, 1, 1, '2018-07-10 10:40:38'),
(520, 3, 11, 1, 0, 0, 0, '2018-07-10 10:40:38'),
(521, 3, 12, 1, 1, 1, 1, '2018-07-10 10:47:00'),
(522, 3, 13, 1, 1, 1, 1, '2018-07-10 10:47:00'),
(523, 3, 14, 1, 0, 0, 0, '2018-07-10 10:47:00'),
(524, 3, 86, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(525, 3, 87, 1, 0, 0, 0, '2018-07-10 10:48:44'),
(526, 3, 88, 1, 1, 1, 0, '2018-07-10 10:48:44'),
(527, 3, 89, 1, 0, 0, 0, '2018-07-10 10:48:44'),
(528, 3, 90, 1, 1, 0, 1, '2018-07-10 10:48:44'),
(529, 3, 91, 1, 0, 0, 0, '2018-07-10 10:48:44'),
(530, 3, 108, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(531, 3, 109, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(532, 3, 110, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(533, 3, 111, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(534, 3, 112, 1, 1, 1, 1, '2018-07-10 10:48:44'),
(535, 3, 127, 1, 0, 0, 0, '2018-07-10 10:48:44'),
(536, 3, 129, 0, 1, 0, 1, '2018-07-10 10:48:44'),
(537, 3, 43, 1, 1, 1, 1, '2018-07-10 10:49:49'),
(538, 3, 44, 1, 0, 0, 0, '2018-07-10 10:49:49'),
(539, 3, 46, 1, 0, 0, 0, '2018-07-10 10:49:49'),
(540, 3, 31, 1, 0, 0, 0, '2018-07-10 10:50:38'),
(541, 3, 32, 1, 1, 1, 1, '2018-07-10 10:50:38'),
(542, 3, 33, 1, 1, 1, 1, '2018-07-10 10:50:38'),
(543, 3, 34, 1, 1, 1, 1, '2018-07-10 10:50:38'),
(544, 3, 35, 1, 1, 1, 1, '2018-07-10 10:50:38'),
(545, 3, 104, 1, 1, 1, 1, '2018-07-10 10:50:38'),
(546, 3, 37, 1, 1, 1, 1, '2018-07-10 10:52:17'),
(547, 3, 38, 1, 1, 1, 1, '2018-07-10 10:52:17'),
(548, 3, 39, 1, 1, 1, 1, '2018-07-10 10:52:17'),
(549, 3, 124, 1, 0, 0, 0, '2018-07-10 10:52:17'),
(553, 6, 78, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(554, 6, 79, 1, 1, 0, 1, '2018-07-10 11:02:18'),
(555, 6, 80, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(556, 6, 81, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(557, 6, 82, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(558, 6, 83, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(559, 6, 84, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(560, 6, 85, 1, 1, 1, 1, '2018-07-10 11:02:18'),
(561, 6, 86, 1, 0, 0, 0, '2018-07-10 11:11:10'),
(574, 6, 43, 1, 1, 1, 1, '2018-07-10 11:05:33'),
(575, 6, 44, 1, 0, 0, 0, '2018-07-10 11:05:33'),
(576, 6, 46, 1, 0, 0, 0, '2018-07-10 11:05:33'),
(578, 6, 102, 1, 1, 1, 1, '2018-07-10 11:20:33'),
(579, 4, 28, 1, 1, 1, 1, '2018-07-10 11:23:54'),
(580, 4, 29, 1, 0, 0, 0, '2018-07-10 11:23:54'),
(581, 4, 30, 1, 0, 0, 0, '2018-07-10 11:23:54'),
(582, 4, 123, 1, 0, 0, 0, '2018-07-10 11:23:54'),
(583, 4, 86, 1, 0, 0, 0, '2018-07-10 11:24:13'),
(584, 4, 43, 1, 1, 1, 1, '2018-07-10 11:25:14'),
(585, 4, 44, 1, 0, 0, 0, '2018-07-10 11:25:14'),
(586, 4, 46, 1, 0, 0, 0, '2018-07-10 11:25:14'),
(588, 2, 102, 1, 1, 1, 1, '2018-07-12 03:47:45'),
(589, 2, 106, 1, 0, 0, 0, '2018-07-10 11:25:37'),
(590, 2, 117, 1, 0, 0, 0, '2018-07-10 11:25:37'),
(591, 3, 40, 1, 1, 1, 1, '2018-07-10 11:28:12'),
(592, 3, 41, 1, 1, 1, 1, '2018-07-10 11:28:12'),
(593, 3, 42, 1, 1, 1, 1, '2018-07-10 11:28:12'),
(594, 3, 125, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(595, 3, 48, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(596, 3, 49, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(597, 3, 102, 1, 1, 1, 1, '2018-07-10 11:28:12'),
(598, 3, 106, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(599, 3, 113, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(600, 3, 114, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(601, 3, 115, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(602, 3, 116, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(603, 3, 117, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(604, 3, 118, 1, 0, 0, 0, '2018-07-10 11:28:12'),
(609, 6, 117, 1, 0, 0, 0, '2018-07-10 11:30:48'),
(611, 2, 86, 1, 0, 0, 0, '2018-07-10 11:38:49'),
(612, 1, 44, 1, 0, 0, 0, '2018-07-10 13:00:31'),
(613, 1, 46, 1, 0, 0, 0, '2018-07-10 13:00:31'),
(616, 1, 127, 1, 0, 0, 0, '2018-07-11 06:22:46'),
(617, 2, 17, 1, 1, 1, 1, '2018-07-11 10:25:14'),
(618, 2, 19, 1, 1, 1, 0, '2018-07-11 10:25:14'),
(619, 2, 20, 1, 1, 1, 1, '2018-07-11 10:25:14'),
(620, 2, 76, 1, 1, 1, 0, '2018-07-11 10:25:14'),
(621, 2, 107, 1, 0, 0, 0, '2018-07-11 10:26:27'),
(622, 2, 121, 1, 0, 0, 0, '2018-07-11 10:26:27'),
(623, 2, 128, 0, 1, 0, 1, '2018-07-11 10:26:27'),
(625, 1, 28, 1, 1, 1, 1, '2018-07-11 12:57:18'),
(626, 6, 1, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(627, 6, 21, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(628, 6, 22, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(629, 6, 23, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(630, 6, 24, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(631, 6, 25, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(632, 6, 77, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(633, 6, 106, 1, 0, 0, 0, '2018-07-12 03:53:47'),
(634, 4, 102, 1, 1, 1, 1, '2018-07-12 03:54:23'),
(635, 4, 106, 1, 0, 0, 0, '2018-07-12 03:54:23'),
(636, 4, 117, 1, 0, 0, 0, '2018-07-12 03:54:23');

-- --------------------------------------------------------

--
-- Table structure for table `room_types`
--

CREATE TABLE `room_types` (
  `id` int(11) NOT NULL,
  `room_type` varchar(200) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `school_houses`
--

CREATE TABLE `school_houses` (
  `id` int(11) NOT NULL,
  `house_name` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `is_active` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sch_settings`
--

CREATE TABLE `sch_settings` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `lang_id` int(11) DEFAULT NULL,
  `dise_code` varchar(50) DEFAULT NULL,
  `date_format` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `is_rtl` varchar(10) DEFAULT 'disabled',
  `timezone` varchar(30) DEFAULT 'UTC',
  `session_id` int(11) DEFAULT NULL,
  `start_month` varchar(40) NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `theme` varchar(200) NOT NULL DEFAULT 'default.jpg',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL,
  `cron_secret_key` varchar(100) NOT NULL,
  `fee_due_days` int(3) DEFAULT 0,
  `class_teacher` varchar(100) NOT NULL,
  `mobile_api_url` text NOT NULL,
  `app_primary_color_code` varchar(20) DEFAULT NULL,
  `app_secondary_color_code` varchar(20) DEFAULT NULL,
  `app_logo` varchar(250) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sch_settings`
--

INSERT INTO `sch_settings` (`id`, `name`, `email`, `phone`, `address`, `lang_id`, `dise_code`, `date_format`, `currency`, `currency_symbol`, `is_rtl`, `timezone`, `session_id`, `start_month`, `image`, `theme`, `is_active`, `created_at`, `updated_at`, `cron_secret_key`, `fee_due_days`, `class_teacher`, `mobile_api_url`, `app_primary_color_code`, `app_secondary_color_code`, `app_logo`) VALUES
(1, 'Garland', 'galand@gmail.com', '0774233045', 'GRANNARY, ZVIMBA', 4, 'G123GRANNARY', 'd-M-Y', 'USD', '$', 'disabled', 'Africa/Harare', 18, '9', '1.png', 'default.jpg', 'no', '2022-11-24 05:04:35', '0000-00-00 00:00:00', '', 0, 'no', '', '#424242', '#eeeeee', '1.png');

-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

CREATE TABLE `sections` (
  `id` int(11) NOT NULL,
  `section` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sections`
--

INSERT INTO `sections` (`id`, `section`, `is_active`, `created_at`, `updated_at`) VALUES
(7, 'A', 'no', '2022-11-24 04:01:42', ''),
(8, 'B', 'no', '2022-11-24 04:01:46', ''),
(9, 'C', 'no', '2022-11-24 04:01:50', ''),
(10, 'D', 'no', '2022-11-24 04:01:54', ''),
(11, 'Blue', 'no', '2022-11-24 04:01:58', ''),
(12, 'Green', 'no', '2022-11-24 04:02:03', ''),
(13, 'Yellow', 'no', '2022-11-24 04:02:07', '');

-- --------------------------------------------------------

--
-- Table structure for table `send_notification`
--

CREATE TABLE `send_notification` (
  `id` int(11) NOT NULL,
  `title` varchar(50) DEFAULT NULL,
  `publish_date` date DEFAULT NULL,
  `date` date DEFAULT NULL,
  `message` text DEFAULT NULL,
  `visible_student` varchar(10) NOT NULL DEFAULT 'no',
  `visible_staff` varchar(10) NOT NULL DEFAULT 'no',
  `visible_parent` varchar(10) NOT NULL DEFAULT 'no',
  `created_by` varchar(60) DEFAULT NULL,
  `created_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `send_notification`
--

INSERT INTO `send_notification` (`id`, `title`, `publish_date`, `date`, `message`, `visible_student`, `visible_staff`, `visible_parent`, `created_by`, `created_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'New Software Update Launch', '2022-11-24', '2022-11-24', '<h4>\r\n\r\nAdd Income- Go to Income > Add Income select Income Head then enter Income Name then \r\nInvoice Number, Date of Income then Amount then Attach Document then Description & click \r\non Save button. Recently added 10 Incomes can be see right side of this page.\r\n\r\n<br></h4>', 'Yes', 'Yes', 'No', 'Super Admin', 1, 'no', '2022-11-24 06:46:11', '');

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` int(11) NOT NULL,
  `session` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sessions`
--

INSERT INTO `sessions` (`id`, `session`, `is_active`, `created_at`, `updated_at`) VALUES
(7, '2016-17', 'no', '2017-04-20 04:42:19', '0000-00-00 00:00:00'),
(11, '2017-18', 'no', '2017-04-20 04:41:37', '0000-00-00 00:00:00'),
(13, '2018-19', 'no', '2016-08-24 17:26:44', '0000-00-00 00:00:00'),
(14, '2019-20', 'no', '2016-08-24 17:26:55', '0000-00-00 00:00:00'),
(15, '2020-21', 'no', '2016-10-01 03:28:08', '0000-00-00 00:00:00'),
(16, '2021-22', 'no', '2016-10-01 03:28:20', '0000-00-00 00:00:00'),
(18, '2022-23', 'no', '2016-10-01 03:29:02', '0000-00-00 00:00:00'),
(19, '2023-24', 'no', '2016-10-01 03:29:10', '0000-00-00 00:00:00'),
(20, '2024-25', 'no', '2016-10-01 03:29:18', '0000-00-00 00:00:00'),
(21, '2025-26', 'no', '2016-10-01 03:30:10', '0000-00-00 00:00:00'),
(22, '2026-27', 'no', '2016-10-01 03:30:18', '0000-00-00 00:00:00'),
(23, '2027-28', 'no', '2016-10-01 03:30:24', '0000-00-00 00:00:00'),
(24, '2028-29', 'no', '2016-10-01 03:30:30', '0000-00-00 00:00:00'),
(25, '2029-30', 'no', '2016-10-01 03:30:37', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `sms_config`
--

CREATE TABLE `sms_config` (
  `id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `api_id` varchar(100) NOT NULL,
  `authkey` varchar(100) NOT NULL,
  `senderid` varchar(100) NOT NULL,
  `contact` text DEFAULT NULL,
  `username` varchar(150) DEFAULT NULL,
  `url` varchar(150) DEFAULT NULL,
  `password` varchar(150) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'disabled',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `source`
--

CREATE TABLE `source` (
  `id` int(11) NOT NULL,
  `source` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sport`
--

CREATE TABLE `sport` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(50) NOT NULL,
  `sportcode` varchar(200) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `across` varchar(200) NOT NULL,
  `down` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `age_group` varchar(200) NOT NULL,
  `team` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `sport`
--

INSERT INTO `sport` (`id`, `date_captured`, `sportcode`, `name`, `description`, `across`, `down`, `gender`, `age_group`, `team`, `active`) VALUES
(1, '2022-11-09 12:47:54pm', 'soc22', 'soccer', 'sport', '9', '9', 'Male', 'under 16', 'house 1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sport_categories`
--

CREATE TABLE `sport_categories` (
  `id` int(11) NOT NULL,
  `sport` varchar(200) NOT NULL,
  `age_group` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `sport_categories`
--

INSERT INTO `sport_categories` (`id`, `sport`, `age_group`, `gender`, `active`) VALUES
(1, 'soccer', 'under 16', 'Male', 1);

-- --------------------------------------------------------

--
-- Table structure for table `staff`
--

CREATE TABLE `staff` (
  `id` int(11) NOT NULL,
  `employee_id` varchar(200) NOT NULL,
  `department` varchar(100) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `qualification` varchar(200) NOT NULL,
  `work_exp` varchar(200) NOT NULL,
  `name` varchar(200) NOT NULL,
  `surname` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `emergency_contact_no` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `dob` date NOT NULL,
  `marital_status` varchar(100) NOT NULL,
  `date_of_joining` date NOT NULL,
  `date_of_leaving` date NOT NULL,
  `local_address` varchar(300) NOT NULL,
  `permanent_address` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  `image` varchar(200) NOT NULL,
  `password` varchar(250) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `account_title` varchar(200) NOT NULL,
  `bank_account_no` varchar(200) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `bank_branch` varchar(100) NOT NULL,
  `payscale` varchar(200) NOT NULL,
  `basic_salary` varchar(200) NOT NULL,
  `epf_no` varchar(200) NOT NULL,
  `contract_type` varchar(100) NOT NULL,
  `shift` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `facebook` varchar(200) NOT NULL,
  `twitter` varchar(200) NOT NULL,
  `linkedin` varchar(200) NOT NULL,
  `instagram` varchar(200) NOT NULL,
  `resume` varchar(200) NOT NULL,
  `joining_letter` varchar(200) NOT NULL,
  `resignation_letter` varchar(200) NOT NULL,
  `other_document_name` varchar(200) NOT NULL,
  `other_document_file` varchar(200) NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `verification_code` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `staff`
--

INSERT INTO `staff` (`id`, `employee_id`, `department`, `designation`, `qualification`, `work_exp`, `name`, `surname`, `father_name`, `mother_name`, `contact_no`, `emergency_contact_no`, `email`, `dob`, `marital_status`, `date_of_joining`, `date_of_leaving`, `local_address`, `permanent_address`, `note`, `image`, `password`, `gender`, `account_title`, `bank_account_no`, `bank_name`, `ifsc_code`, `bank_branch`, `payscale`, `basic_salary`, `epf_no`, `contract_type`, `shift`, `location`, `facebook`, `twitter`, `linkedin`, `instagram`, `resume`, `joining_letter`, `resignation_letter`, `other_document_name`, `other_document_file`, `user_id`, `is_active`, `verification_code`) VALUES
(1, '', '', '', '', '', 'Super Admin', '', '', '', '', '', 'superadmin@gmail.com', '0000-00-00', '', '0000-00-00', '0000-00-00', '', '', '', '', '$2y$10$FR4uLfdq6eRk6Wu1WnD21OMbtQnLoNYf5pm0WPVkEp/UuqLfqLOzi', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, ''),
(2, 'GDM123H', '1', '1', 'BSc Honors In Information Technology', '2 years in Ministry', 'DANIEL', 'MAODZEKA', '', '', '0774233045', '0772330945', 'dkmao@gmail.com', '1997-11-16', 'Married', '2022-09-21', '0000-00-00', '164 st, warren park, harare', '', 'Reday to work', '2.png', '$2y$10$Z9JdCuvMWO5zTJXQRyP0.OhlADkbsVDaHLhOmU/HcJ8gfyvptOalG', 'Male', 'debit', '2000838902', 'steard', '', 'kwameh', '', '200', 'dkm123', 'permanent', '1', 'harare', '', '', '', '', '', '', '', 'Other Document', '', 0, 0, ''),
(3, 'STA001', '3', '2', 'BSC. honors in Information Technology', 'elmaz technologies', 'Daniel', 'Maodzeka', '', '', '0774233045', '0772330945', 'dkmaodzeka@gmail.com', '1997-11-16', 'Single', '2020-01-01', '0000-00-00', '164 street, 3639 warren park d, harare', '3206, grannary phase 2b, harare', 'a good teacher in english language', '', '$2y$10$qb2DYaFb/i22C/GkfCNGV.vFNekxYq7lfefX1XdFMA.mDFGVNURRu', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 0, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `staff_attendance`
--

CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL,
  `date` date NOT NULL,
  `staff_id` int(11) NOT NULL,
  `staff_attendance_type_id` int(11) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `staff_attendance_type`
--

CREATE TABLE `staff_attendance_type` (
  `id` int(11) NOT NULL,
  `type` varchar(200) NOT NULL,
  `key_value` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `staff_attendance_type`
--

INSERT INTO `staff_attendance_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Present', '<b class=\"text text-success\">P</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 'Late', '<b class=\"text text-warning\">L</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 'Absent', '<b class=\"text text-danger\">A</b>', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 'Half Day', '<b class=\"text text-warning\">F</b>', 'yes', '2018-05-06 23:56:16', '0000-00-00 00:00:00'),
(5, 'Holiday', 'H', 'yes', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `staff_designation`
--

CREATE TABLE `staff_designation` (
  `id` int(11) NOT NULL,
  `designation` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `staff_designation`
--

INSERT INTO `staff_designation` (`id`, `designation`, `is_active`) VALUES
(2, 'English Teacher', 'yes'),
(3, 'Shona Teacher', 'yes'),
(4, 'Maths Teacher', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `staff_leave_details`
--

CREATE TABLE `staff_leave_details` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `alloted_leave` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `staff_leave_request`
--

CREATE TABLE `staff_leave_request` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `leave_from` date NOT NULL,
  `leave_to` date NOT NULL,
  `leave_days` int(11) NOT NULL,
  `employee_remark` varchar(200) NOT NULL,
  `admin_remark` varchar(200) NOT NULL,
  `status` varchar(100) NOT NULL,
  `applied_by` varchar(200) NOT NULL,
  `document_file` varchar(200) NOT NULL,
  `date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `staff_payroll`
--

CREATE TABLE `staff_payroll` (
  `id` int(11) NOT NULL,
  `basic_salary` int(11) NOT NULL,
  `pay_scale` varchar(200) NOT NULL,
  `grade` varchar(50) NOT NULL,
  `is_active` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `staff_payslip`
--

CREATE TABLE `staff_payslip` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `basic` int(11) NOT NULL,
  `total_allowance` int(11) NOT NULL,
  `total_deduction` int(11) NOT NULL,
  `leave_deduction` int(11) NOT NULL,
  `tax` varchar(200) NOT NULL,
  `net_salary` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  `month` varchar(200) NOT NULL,
  `year` varchar(200) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `payment_date` date NOT NULL,
  `remark` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `staff_payslip`
--

INSERT INTO `staff_payslip` (`id`, `staff_id`, `basic`, `total_allowance`, `total_deduction`, `leave_deduction`, `tax`, `net_salary`, `status`, `month`, `year`, `payment_mode`, `payment_date`, `remark`) VALUES
(1, 1, 0, 20, 4, 0, '0', 16, 'generated', 'August', '2022', '', '2022-09-15', '');

-- --------------------------------------------------------

--
-- Table structure for table `staff_roles`
--

CREATE TABLE `staff_roles` (
  `id` int(11) NOT NULL,
  `role_id` int(11) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `staff_roles`
--

INSERT INTO `staff_roles` (`id`, `role_id`, `staff_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 7, 1, 0, '2022-08-11 15:24:34', '0000-00-00 00:00:00'),
(2, 2, 2, 0, '2022-09-21 05:13:19', ''),
(3, 2, 3, 0, '2022-11-24 04:31:26', '');

-- --------------------------------------------------------

--
-- Table structure for table `staff_timeline`
--

CREATE TABLE `staff_timeline` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(300) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `students`
--

CREATE TABLE `students` (
  `id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `admission_no` varchar(100) DEFAULT NULL,
  `roll_no` varchar(100) DEFAULT NULL,
  `admission_date` varchar(100) DEFAULT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `rte` varchar(20) NOT NULL DEFAULT 'No',
  `image` varchar(100) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `pincode` varchar(100) DEFAULT NULL,
  `religion` varchar(100) DEFAULT NULL,
  `cast` varchar(50) NOT NULL,
  `dob` varchar(100) DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `category_id` varchar(100) DEFAULT NULL,
  `route_id` int(11) NOT NULL,
  `school_house_id` int(11) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `vehroute_id` int(11) NOT NULL,
  `hostel_room_id` int(11) NOT NULL,
  `adhar_no` varchar(100) DEFAULT NULL,
  `samagra_id` varchar(100) DEFAULT NULL,
  `bank_account_no` varchar(100) DEFAULT NULL,
  `bank_name` varchar(100) DEFAULT NULL,
  `ifsc_code` varchar(100) DEFAULT NULL,
  `guardian_is` varchar(100) NOT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `father_phone` varchar(100) DEFAULT NULL,
  `father_occupation` varchar(100) DEFAULT NULL,
  `mother_name` varchar(100) DEFAULT NULL,
  `mother_phone` varchar(100) DEFAULT NULL,
  `mother_occupation` varchar(100) DEFAULT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `guardian_relation` varchar(100) DEFAULT NULL,
  `guardian_phone` varchar(100) DEFAULT NULL,
  `guardian_occupation` varchar(150) NOT NULL,
  `guardian_address` text DEFAULT NULL,
  `guardian_email` varchar(100) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `guardian_pic` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `previous_school` text DEFAULT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `measurement_date` date NOT NULL,
  `app_key` text DEFAULT NULL,
  `parent_app_key` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL,
  `disable_at` date NOT NULL,
  `note` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `students`
--

INSERT INTO `students` (`id`, `parent_id`, `admission_no`, `roll_no`, `admission_date`, `firstname`, `lastname`, `rte`, `image`, `mobileno`, `email`, `state`, `city`, `pincode`, `religion`, `cast`, `dob`, `gender`, `current_address`, `permanent_address`, `category_id`, `route_id`, `school_house_id`, `blood_group`, `vehroute_id`, `hostel_room_id`, `adhar_no`, `samagra_id`, `bank_account_no`, `bank_name`, `ifsc_code`, `guardian_is`, `father_name`, `father_phone`, `father_occupation`, `mother_name`, `mother_phone`, `mother_occupation`, `guardian_name`, `guardian_relation`, `guardian_phone`, `guardian_occupation`, `guardian_address`, `guardian_email`, `father_pic`, `mother_pic`, `guardian_pic`, `is_active`, `previous_school`, `height`, `weight`, `measurement_date`, `app_key`, `parent_app_key`, `created_at`, `updated_at`, `disable_at`, `note`) VALUES
(1, 2, 'c17131292e', '1', '2022-07-14', 'daniel', 'maodzeka', 'No', 'uploads/student_images/no_image.png', '0774233045', 'dkmao@gmail.com', NULL, NULL, NULL, 'christian', '990', '1997-11-16', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'kennedy', '0772330945', 'MANAGER', 'NONE', 'none2', 'nothing', 'kennedy', 'Father', '0772330945', 'MANAGER', '', 'dk@gmail.com', '', '', '', 'yes', '', '', '', '2022-07-14', NULL, NULL, '2022-07-14 11:09:32', '0000-00-00 00:00:00', '0000-00-00', ''),
(2, 4, 'GM123H', '1', '2022-09-21', 'GETTY', 'MAODZEKA', 'No', 'uploads/student_images/2.png', '0772112334', 'dkmaodzeka@gmail.com', NULL, NULL, NULL, 'Christian', '', '2001-06-24', 'Female', '', '', '1', 0, 0, 'A+', 0, 0, '', '', '', '', '', 'father', 'daniel', '0774233045', 'manager', 'yvette', '0785076046', 'manager', 'daniel', 'Father', '0774233045', 'manager', 'harare belgravia', 'dkmao@gmail.com', '', '', '', 'yes', '', '', '', '2022-09-21', NULL, NULL, '2022-09-21 05:23:34', '', '0000-00-00', ''),
(3, 6, 'LEA001', '001', '2022-11-24', 'Tafadzwa', 'Musenda', 'No', 'uploads/student_images/no_image.png', '', '', NULL, NULL, NULL, 'Christian', '', '2019-02-13', 'Male', '', '', '1', 0, 0, '', 0, 0, '', '', '', '', '', 'father', 'Mr Musenda', '0774123141', 'Employee', 'Mrs Musenda', '0778665121', 'Mr Musenda', 'Mr Musenda', 'Father', '0774123141', 'Employee', '', '', '', '', '', 'yes', '', '', '', '2022-11-24', NULL, NULL, '2022-11-24 04:38:40', '', '0000-00-00', ''),
(4, 0, 'LEA002', '2', '2022-12-01', 'Princess', 'Gurure', 'No', 'uploads/student_images/no_image.png', '0787000306', 'gurureprincess@gmail.com', NULL, NULL, NULL, 'AFM', '1', '2007-05-26', 'Female', '', '', '1', 0, 0, 'O+', 0, 0, '', '', '', '', '', 'mother', 'Jotham', '0774231431', 'Civil Engineer', 'Gladys', '0774725890', 'Electrical Engineer', 'Gladys', 'Mother', '0774725890', 'Electrical Engineer', '235 Old Marimba Mufakose Harare', 'cgladys@gmaiil.com', '', '', '', 'yes', '', '1.2', '45', '2022-12-01', NULL, NULL, '2023-01-10 09:03:28', '', '0000-00-00', '');

-- --------------------------------------------------------

--
-- Table structure for table `student_attendences`
--

CREATE TABLE `student_attendences` (
  `id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `attendence_type_id` int(11) DEFAULT NULL,
  `remark` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `student_attendences`
--

INSERT INTO `student_attendences` (`id`, `student_session_id`, `date`, `attendence_type_id`, `remark`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 3, '2022-11-24', 1, '', 'no', '2022-11-24 05:20:02', '');

-- --------------------------------------------------------

--
-- Table structure for table `student_doc`
--

CREATE TABLE `student_doc` (
  `id` int(11) NOT NULL,
  `student_id` int(11) DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `doc` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_fees`
--

CREATE TABLE `student_fees` (
  `id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `feemaster_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `amount_discount` float(10,2) NOT NULL,
  `amount_fine` float(10,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `date` varchar(50) NOT NULL,
  `payment_mode` varchar(50) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_fees_deposite`
--

CREATE TABLE `student_fees_deposite` (
  `id` int(11) NOT NULL,
  `student_fees_master_id` int(11) DEFAULT NULL,
  `student_group_id` int(11) NOT NULL,
  `fee_groups_feetype_id` int(11) DEFAULT NULL,
  `amount_detail` text DEFAULT NULL,
  `receipt` varchar(20) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `student_fees_deposite`
--

INSERT INTO `student_fees_deposite` (`id`, `student_fees_master_id`, `student_group_id`, `fee_groups_feetype_id`, `amount_detail`, `receipt`, `is_active`, `created_at`) VALUES
(26, 2, 0, 5, '{\"1\":{\"amount\":\"40\",\"date\":\"2022-12-08\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"FEE Collected By: Super Admin\",\"payment_mode\":\"RTGS-ZWL\",\"inv_no\":1}}', 'REC0004', 'no', '2022-12-08 11:05:27'),
(27, 2, 0, 6, '{\"1\":{\"amount\":\"20\",\"date\":\"2022-12-08\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"FEE Collected By: Super Admin\",\"payment_mode\":\"RTGS-ZWL\",\"inv_no\":1}}', 'REC0005', 'no', '2022-12-08 11:05:39'),
(29, 2, 0, 4, '{\"1\":{\"amount\":\"70\",\"date\":\"2022-12-16\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"adm\",\"payment_mode\":\"RTGS\",\"inv_no\":1},\"2\":{\"amount\":\"10\",\"date\":\"2022-12-16\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"ADM\",\"payment_mode\":\"RTGS\",\"inv_no\":2},\"3\":{\"amount\":0.14285714285714285,\"date\":\"2022-12-16\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"adm\",\"payment_mode\":\"RTGS\",\"inv_no\":3},\"4\":{\"amount\":15.715510204081633,\"date\":\"2022-12-16\",\"amount_discount\":\"0\",\"amount_fine\":\"0\",\"description\":\"adm\",\"payment_mode\":\"RTGS\",\"inv_no\":4}}', 'REC0004', 'no', '2022-12-16 12:10:23');

-- --------------------------------------------------------

--
-- Table structure for table `student_fees_discounts`
--

CREATE TABLE `student_fees_discounts` (
  `id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `fees_discount_id` int(11) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'assigned',
  `payment_id` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `student_fees_discounts`
--

INSERT INTO `student_fees_discounts` (`id`, `student_session_id`, `fees_discount_id`, `status`, `payment_id`, `description`, `is_active`, `created_at`) VALUES
(1, 2, 1, 'applied', '10/1', 'admission fee Collected By: Super Admin', 'no', '2022-11-11 09:50:10'),
(2, 3, 1, 'applied', '23', 'discount', 'no', '2023-01-10 09:09:32');

-- --------------------------------------------------------

--
-- Table structure for table `student_fees_master`
--

CREATE TABLE `student_fees_master` (
  `id` int(11) NOT NULL,
  `is_system` int(1) NOT NULL DEFAULT 0,
  `student_session_id` int(11) DEFAULT NULL,
  `fee_session_group_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT 0.00,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `invoice` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `student_fees_master`
--

INSERT INTO `student_fees_master` (`id`, `is_system`, `student_session_id`, `fee_session_group_id`, `amount`, `is_active`, `created_at`, `invoice`) VALUES
(1, 0, 2, 1, 0.00, 'no', '2022-09-21 05:28:57', ''),
(2, 0, 3, 2, 0.00, 'no', '2022-11-24 04:53:55', ''),
(4, 0, 4, 2, 0.00, 'no', '2022-12-06 07:29:43', '');

-- --------------------------------------------------------

--
-- Table structure for table `student_session`
--

CREATE TABLE `student_session` (
  `id` int(11) NOT NULL,
  `session_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `route_id` int(11) NOT NULL,
  `hostel_room_id` int(11) NOT NULL,
  `vehroute_id` int(10) DEFAULT NULL,
  `transport_fees` float(10,2) NOT NULL DEFAULT 0.00,
  `fees_discount` float(10,2) NOT NULL DEFAULT 0.00,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `student_session`
--

INSERT INTO `student_session` (`id`, `session_id`, `student_id`, `class_id`, `section_id`, `route_id`, `hostel_room_id`, `vehroute_id`, `transport_fees`, `fees_discount`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 14, 1, 1, 1, 0, 0, NULL, 0.00, 0.00, 'no', '2022-07-14 11:09:32', '0000-00-00 00:00:00'),
(2, 18, 2, 2, 4, 0, 0, NULL, 0.00, 0.00, 'no', '2022-09-21 05:23:33', ''),
(3, 18, 3, 9, 13, 0, 0, NULL, 0.00, 0.00, 'no', '2022-11-24 04:38:40', ''),
(4, 18, 0, 9, 13, 0, 0, NULL, 0.00, 0.00, 'no', '2022-12-02 08:52:42', '');

-- --------------------------------------------------------

--
-- Table structure for table `student_sibling`
--

CREATE TABLE `student_sibling` (
  `id` int(11) NOT NULL,
  `student_id` int(11) DEFAULT NULL,
  `sibling_student_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_sport`
--

CREATE TABLE `student_sport` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(100) NOT NULL,
  `sportcode` varchar(100) NOT NULL,
  `student_id` varchar(100) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `student_sport`
--

INSERT INTO `student_sport` (`id`, `date_captured`, `sportcode`, `student_id`, `active`) VALUES
(3, '2022-12-23 10:49:22am', 'soc22', 'LEA001', 1);

-- --------------------------------------------------------

--
-- Table structure for table `student_timeline`
--

CREATE TABLE `student_timeline` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `date` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_transport_fees`
--

CREATE TABLE `student_transport_fees` (
  `id` int(11) NOT NULL,
  `student_session_id` int(11) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `amount_discount` float(10,2) NOT NULL,
  `amount_fine` float(10,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `date` varchar(50) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `payment_mode` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `subjects`
--

CREATE TABLE `subjects` (
  `id` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `code` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `subjects`
--

INSERT INTO `subjects` (`id`, `name`, `code`, `type`, `is_active`, `created_at`, `updated_at`) VALUES
(4, 'English', 'ENG', 'Theory', 'no', '2022-11-24 04:08:43', ''),
(5, 'English Pr', 'ENGP', 'Practical', 'no', '2022-11-24 04:09:25', ''),
(6, 'Maths', 'MATH', 'Practical', 'no', '2022-11-24 04:10:09', ''),
(7, 'Shona', 'SH', 'Theory', 'no', '2022-11-24 04:10:20', '');

-- --------------------------------------------------------

--
-- Table structure for table `supplier`
--

CREATE TABLE `supplier` (
  `id` int(11) NOT NULL,
  `date_captured` varchar(30) NOT NULL,
  `supplier_id` varchar(10) NOT NULL,
  `name` varchar(100) NOT NULL,
  `address` varchar(100) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `email` varchar(100) NOT NULL,
  `currency` varchar(20) NOT NULL,
  `active` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `supplier`
--

INSERT INTO `supplier` (`id`, `date_captured`, `supplier_id`, `name`, `address`, `mobile`, `email`, `currency`, `active`) VALUES
(1, '2022-12-29 09:37:15am', 'S1234E', 'DANIEL', 'HARARE', '0774233045', 'daniel@gmail.com', 'USD', 1);

-- --------------------------------------------------------